const express = require('express');
const path = require('path');
const app = express();
const port = 3000; // Puedes cambiar el puerto si lo necesitas

// 1. Configuración del Motor de Plantillas (EJS)
app.set('view engine', 'ejs');
app.set('views', path.join(__dirname, 'views'));

// 2. Servir Archivos Estáticos (CSS, Imágenes y el Sitio Viejo)
// Todo lo que esté en la carpeta 'public' será accesible directamente
app.use(express.static(path.join(__dirname, 'public')));

// --- RUTAS DE TU NUEVO SITIO WEB ---

// Página de Inicio (renderiza views/index.ejs)
app.get('/', (req, res) => {
    res.render('index', { 
        titulo: 'Inicio - eFactory ERP',
        paginaActual: 'inicio'
    });
});

// Ejemplo de otra página nueva
app.get('/contacto', (req, res) => {
    res.render('contacto', { titulo: 'Contáctanos' });
});

// Ejemplo de otra página nueva
app.get(/\.ejs$/, (req, res) => {
    const filePath = path.join(__dirname, 'views', req.path);
    res.render(filePath, { titulo: 'Página!', paginaActual: 'inicio' });
});


// --- MANEJO DEL SITIO VIEJO (Legacy) ---
// Si una URL termina en .html y no la hemos definido arriba,
// intentamos buscarla en la carpeta /public/legacy
app.get(/\.html$/, (req, res) => {
    // Construye la ruta hacia el archivo viejo
    const legacyPath = path.join(__dirname, 'public', 'legacy', req.path);
    
    // Envía el archivo viejo al navegador
    res.sendFile(legacyPath, (err) => {
        if (err) {
            // Si el archivo viejo no existe, error 404
            res.status(404).send("Página no encontrada en el sistema antiguo.");
        }
    });
});


// Iniciar el servidor
app.listen(port, () => {
  console.log(`Servidor corriendo en http://localhost:${port}`);
  console.log(`Para desarrollar, usa: nodemon app.js`);
});